# Contract security clauses checklist (non-legal)

This checklist is a practical guide to common security terms teams review in vendor contracts. Use it to align procurement, security, and legal.

Important: this is informational and not legal advice. Review contract language with counsel.

## 1) Incident notification and cooperation
- Notification timeline defined (e.g., “without undue delay” is ambiguous).
- Scope of notification includes suspected and confirmed incidents affecting in-scope data.
- Cooperation requirements: provide timeline, scope, and investigation updates.
- Point of contact and update cadence defined.

## 2) Subprocessors and downstream risk
- Subprocessor list disclosure and update cadence.
- Requirement to notify of material subprocessor changes.
- Flow-down security obligations to subprocessors.

## 3) Access controls and least privilege
- Vendor restricts access to authorized personnel only.
- MFA required for privileged and administrative access.
- Support access is approved and time-boxed where possible.
- Access is logged and logs are retained for a defined period.

## 4) Data protection
- Encryption in transit and at rest expectations.
- Data retention and deletion requirements (including post-termination).
- Data residency or processing location commitments (if needed).
- Secure disposal requirements for backups and media (if applicable).

## 5) Audit rights and assurance artifacts
- What third-party reports are available (SOC 2, ISO, pen test summaries) and how shared.
- Audit rights and limitations (avoid “unlimited audit” if impractical; define reasonable terms).
- Evidence sharing method (agreement-required, time windows, watermarking).

## 6) Service availability and continuity
- Availability commitments (if required) and measurement method.
- Backup and recovery expectations for in-scope data.
- Disaster recovery responsibilities and testing cadence (if applicable).

## 7) Termination and data return
- Data return and deletion timelines post-termination.
- Confirmation of deletion (certificate or statement) when required.
- Handling of legal holds or regulatory retention exceptions.

## 8) Liability and insurance (coordinate with legal)
- Liability caps and exclusions understood.
- Cyber insurance requirements (if applicable).
- Indemnity terms reviewed for security incidents affecting your data.

## 9) Practical “gotchas”
- Vague incident notification language with no timeline.
- No subprocessor transparency while vendor processes sensitive data.
- No ability to obtain basic assurance artifacts under agreement.
- Support access model unclear or unlogged.
