# Aurora Command: Vendor Risk Assessment Template

Standardize vendor security reviews without spreadsheet sprawl.

This template helps you:
- Ask consistent questions (and avoid over-collecting).
- Track ownership, evidence links, and review dates.
- Produce a due diligence evidence set you can reuse for audits and buyer reviews.

## Who this is for
- Security and compliance teams reviewing vendors/subprocessors
- Engineering and procurement stakeholders who need a consistent workflow

## Expected outputs (what you will produce)
- A completed vendor questionnaire with linked evidence
- A risk decision record (approve/deny/approve with exceptions)
- A due diligence evidence set structure for storage and sharing
- A repeatable tiering model so low-risk vendors do not consume the same time as critical ones

## Scope (what this set covers)
- Vendor/subprocessor onboarding and periodic reviews
- Risk tiering based on **criticality** and **data exposure**
- Evidence indexing (artifact IDs, capture dates, expiration, and notes)
- Decision trails (conditions, exceptions, approvals, next review date)
- Incident follow-up questions (what you ask vendors when something happens)

This set does not provide legal advice or contractual commitments.

## Included files
- `vendor-risk-assessment-template.csv`: the review questionnaire and tracking fields
- `risk-rating-rubric.md`: how to score and decide consistently
- `review-workflow.md`: assign, collect, score, decide, export
- `due-diligence-export-structure.md`: recommended evidence set structure (what to save for later)
- `evidence-index-template.csv`: index vendor artifacts with capture dates and expiration
- `vendor-decision-memo-template.md`: decision memo template (scope, findings, conditions, next review)
- `vendor-tiering-model.md`: tiering model (criticality and data exposure)
- `contract-security-clauses-checklist.md`: non-legal checklist of common vendor security terms to review
- `vendor-incident-questionnaire.md`: what to ask vendors during an incident or suspected exposure

## Quick start (60 minutes)
1) Pick one in-scope vendor and assign a review owner (security/compliance) and a business owner.
2) Use `vendor-tiering-model.md` to assign a tier (so you don’t over-collect for low-risk vendors).
3) Open `vendor-risk-assessment-template.csv` and delete sections that are out of scope for this vendor tier.
4) Create an evidence index using `evidence-index-template.csv` so artifacts have IDs, capture dates, and expiration.
5) Record your decision using `vendor-decision-memo-template.md` (or a decision log) and time-box conditions.

## Quality bar (what makes a vendor review defensible)
- Scope is explicit: what service is being reviewed and how it is used in your environment.
- Data exposure is explicit: what data categories are involved and where the vendor has access.
- Evidence is indexed with capture dates and expiration (no “we saw it once” screenshots).
- Decisions are traceable: approvals, conditions, and next review dates are recorded.
- Exceptions are explicit and time-boxed (owner, target date, compensating controls).

## Common pitfalls (and how to avoid them)
- **Over-collecting**: asking every vendor for everything.
  Use tiering to request deep artifacts only from high-risk vendors.
- **Losing the decision trail**: decisions made in email/slack with no record.
  Keep a decision memo/log and attach conditions to specific artifacts and dates.
- **Stale evidence**: artifacts with no capture dates.
  Treat evidence like inventory: capture date, expiration, cadence.
- **Scope drift**: the vendor expands usage and you don’t re-review.
  Re-tier and re-score when data exposure or criticality changes.

## Notes
- This template is informational and is not legal advice.
- Tailor questions and thresholds to your data sensitivity and contract requirements.
