# Aurora Command: SOC 2 Evidence Checklist

Build a repeatable SOC 2 evidence program that stays current between audits.

This checklist set is designed for real-world SOC 2 execution:
- Evidence requests arrive late and often change mid-stream.
- Auditors sample across time, so “we have a policy” is not sufficient without timestamps.
- The fastest teams treat evidence like inventory: owners, cadence, and freshness are explicit.

## Who this is for
- Compliance owners running SOC 2 readiness or recurring audits
- Security leads who need defensible evidence without spreadsheet sprawl
- Engineering/IT partners responsible for identity, logging, and change controls

## Expected outputs (what you will produce)
- A clear scope definition (systems, people, and boundaries)
- An evidence inventory with artifact IDs, owners, capture dates, and cadence
- A PBC tracker to manage auditor requests and deadlines
- A repeatable “capture vs continuous” evidence strategy

## Scope (what this checklist covers)
- SOC 2 readiness and recurring audits (Type I / Type II programs)
- Evidence packaging that is sampling-ready (capture dates, cadence, source details)
- PBC management (owners, deadlines, and what was delivered)
- Ongoing maintenance (so evidence is current between audits)

This checklist set does not provide legal advice or auditor-specific interpretations of the Trust Services Criteria.

## Quick start (60–90 minutes)
1) Complete `soc2-scoping-worksheet.md` (tight scope prevents rework).
2) Open `soc2-evidence-checklist.csv` and delete items that are out of scope.
3) Assign owners and set cadence for each evidence artifact (quarterly is a common baseline).
4) Start capturing the top 10 evidence items first: identity, logging, change control, incident response.
5) Track auditor requests in `soc2-pbc-tracker-template.csv` so nothing gets dropped.

## How to run a SOC 2 evidence program that stays current
### Treat evidence like inventory (not a last-minute rush)
Auditors sample across time. If evidence freshness is implicit, you will rework the same items every audit cycle.

Recommended pattern:
- Each evidence artifact has an owner, capture date, and refresh cadence.
- Evidence is captured from systems of record (exports/logs > screenshots).
- The evidence index is the “single source of truth” you can hand to auditors.

### Make scope explicit early
Most audit friction comes from scope drift.

Use the scoping worksheet to define:
- What systems are in scope
- What time period is being audited
- What boundaries/exclusions exist

### Keep a PBC tracker and a delivery trail
Use the PBC tracker to record:
- The auditor request
- Who owns the response
- The due date
- Which Evidence IDs were delivered

This prevents “we sent it” ambiguity and makes next year’s audit dramatically easier.

## What’s inside
- `soc2-scoping-worksheet.md`: define scope, boundaries, people, and time period
- `soc2-evidence-checklist.md`: a practical evidence strategy and a reviewer-ready quality bar
- `soc2-evidence-checklist.csv`: evidence inventory (IDs, owners, cadence, capture dates, gating)
- `soc2-pbc-tracker-template.csv`: track PBC requests, owners, deadlines, and evidence IDs

## Notes
- This checklist is informational and is not legal advice.
- SOC 2 scope and evidence expectations vary by auditor and trust service criteria; tailor accordingly.
- If you are unsure whether something is in scope, document the assumption and confirm with your auditor early.
