# Written Information Security Program (WISP) Template

Replace placeholders in `{braces}`.
Keep this document scoped to the systems and data you actually operate.

## 1) Purpose
This Written Information Security Program (WISP) describes how **{Company}** protects **{data types}** in **{in-scope systems}**.

## 2) Scope
This WISP applies to:
- **Products and services:** {list}
- **Environments:** {production / staging / other}
- **Locations and providers:** {cloud provider and regions, or on-prem locations}
- **People:** {employees / contractors / both}

This WISP does not apply to:
- {explicit exclusions}

## 3) Roles and responsibilities
- **Program owner:** {name or role}
- **Security contact:** {email}
- **IT operations:** {team or vendor}
- **Legal and privacy:** {contact}

## 4) Risk assessment and remediation
We perform a risk assessment on a **{cadence}** basis and when major changes occur.
We document remediation items with owners and due dates.

## 5) Access control
We use:
- **Unique user accounts** for workforce access.
- **Multi-factor authentication (MFA)** where supported and appropriate for risk.
- **Role-based access control (RBAC)** to limit access to job needs.

We review access on a **{cadence}** basis.

## 6) Data protection
We protect data with:
- Encryption in transit where supported
- Encryption at rest where supported
- Backups and recovery procedures

## 7) Logging and monitoring
We keep logs for **{retention period}** based on system capability and risk.
We restrict access to logs and record who has administrative access.

## 8) Incident response
We maintain an incident response plan and escalation contacts.
We run incident readiness exercises on a **{cadence}** basis.

## 9) Vendor and subprocessor oversight
We maintain a vendor inventory for vendors that access sensitive data.
We review vendors on a **{cadence}** basis and when material changes occur.

## 10) Security awareness and training
We provide security awareness training for staff on a **{cadence}** basis.
We record completion where applicable.

## 11) Policy review and approval
This WISP is reviewed on a **{cadence}** basis.

**Last reviewed:** {YYYY-MM-DD}

**Approved by:** {name and title}

**Approval date:** {YYYY-MM-DD}

## 12) Exceptions
If an exception is required, we record:
- what is excluded
- why it is excluded
- compensating controls
- owner and target date

